#####################################################################################
# compute a and b

barcodeFiles = c(
"zf_034.txt",
"zf_036.txt",
"zfm19.txt",
"zfm25.txt",
"zfm18.txt",
"zfm21.txt",
"bmp1a_16.txt",
"bmp1a_17.txt",
"bmp1a_19.txt",
"plod2_13.txt",
"plod2_14.txt",
"plod2_15.txt",
"ab young_01.txt",
"ab young_02.txt",
"ab young_03.txt",
"ab young_04.txt")

# genotype of each animal
groupIDs = t(c("ARO","ARO","ARO","ARO","ARO","ARO","bmp1a+/+","bmp1a+/+","bmp1a+/+","plod2+/+","plod2+/+","plod2+/+","AB","AB","AB","AB"))
standardLengths = c(19.0,18.4,24.4,27.9,31.8,30.6,24.8,27.1,25.4,27.1,28.1,28.5,21.1,21.0,20.7,19.7)


# this is the columns of the different parameters
# 1. Row
# 2. VertebralVolumes
# 3. CentrumVolumes
# 4. HaemalVolumes
# 5. NeuralVolumes
# 6. VertebralSAs
# 7. CentrumSAs
# 8. HaemalSAs
# 9. NeuralSAs
# 10. VertebralTMDs
# 11. CentrumTMDs
# 12. HaemalTMDs
# 13. NeuralTMDs
# 14. VertebralISs
# 15. CentrumISs
# 16. HaemalISs
# 17. NeuralISs
# 18. VertebralMTs
# 19. CentrumMTs
# 20. HaemalMTs
# 21. NeuralMTs
# 22. VertebralTSs
# 23. CentrumTSs
# 24. HaemalTSs
# 25. NeuralTSs
# 26. CentrumLength

paramsToAnalyze = c(3:5,11:13,19:21,26) #params to analyze
vertsToAnalyze = c(1:16)

#initialize variables
pcaData = array(0,dim=c(length(vertsToAnalyze)*length(paramsToAnalyze),length(groupIDs)))

aMatrix = array(0,dim=c(length(paramsToAnalyze),length(vertsToAnalyze)))
bMatrix = array(0,dim=c(length(paramsToAnalyze),length(vertsToAnalyze)))
rSquaredMatrix = array(0,dim=c(length(paramsToAnalyze),length(vertsToAnalyze)))

#calculate a and b for each quantity, using standard length as X
for (k in 1:length(paramsToAnalyze)) {
	
	print(k)
	p = paramsToAnalyze[k]
		
	# retrieve values
	allData = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
	for (i in 1:length(groupIDs)) {
		allDataInit = read.table(barcodeFiles[i],header=T)
		allData[i,] = unlist(allDataInit[vertsToAnalyze,p])
	}
	
	if (p==11) {
		
		allData1 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData1[i,] = unlist(allDataInit[vertsToAnalyze,3])
		}
					
		allData2 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData2[i,] = unlist(allDataInit[vertsToAnalyze,11])
		}
		allData = allData1*allData2*(1e-9)		
		
	}
	
	if (p==12) {
		
		allData1 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData1[i,] = unlist(allDataInit[vertsToAnalyze,4])
		}
					
		allData2 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData2[i,] = unlist(allDataInit[vertsToAnalyze,12])
		}
		allData = allData1*allData2*(1e-9)		
		
	}

	if (p==13) {
		
		allData1 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData1[i,] = unlist(allDataInit[vertsToAnalyze,5])
		}
					
		allData2 = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
		for (i in 1:length(groupIDs)) {
			allDataInit = read.table(barcodeFiles[i],header=T)
			allData2[i,] = unlist(allDataInit[vertsToAnalyze,13])
		}
		allData = allData1*allData2*(1e-9)		
		
	}

		
	for (v in 1:length(vertsToAnalyze)) {
		y = log(allData[,v],2)
		x = log(standardLengths,2)
		fit = lm(y~x)
		aMatrix[k,v] = fit$coeff[1]
		bMatrix[k,v] = fit$coeff[2]
		rSquaredMatrix[k,v] = summary(fit)$r.squared

	}
		
}

write(t(aMatrix),file="aMatrix.txt")
write(t(bMatrix),file="bMatrix.txt")
